<?php
namespace App\Models; 

class Meeting extends Model{

    private $tableName='meetings';


	//metodo insertar regiustro
    public function insertar($date,$topic){
        $sql="INSERT INTO $this->tableName (date,topic,status) VALUES (?,?,?)";
        $arrData = array($date,$topic,'1');
        return $this->setData($sql,$arrData);
    }

    public function editar($id,$date,$topic){
        $sql="UPDATE $this->tableName SET date=?,topic=? WHERE id=?";

        $arrData = array($date,$topic,$id);
        return $this->setData($sql,$arrData);
    }

	public function desactivar($id){
		$sql="UPDATE $this->tableName SET status='0' WHERE id=?";
		$arrData = array($id);
		return $this->setData($sql,$arrData);
	}
    
	public function activar($id){
		$sql="UPDATE $this->tableName SET status='1' WHERE id=?";
		$arrData = array($id);
		return $this->setData($sql,$arrData);
	}

	//metodo para mostrar registros
	public function mostrar(string $id){
		$sql="SELECT * FROM $this->tableName WHERE id=?";
		$arrData = array($id);
		return  $this->getData($sql,$arrData); 
	}

	//listar registros
	public function listar(){
		$sql = "SELECT id,date,topic, status
        FROM $this->tableName";

		return  $this->getDataAll($sql); 
	}

	/*public function listaMeetings() {
		$sql = "SELECT m.*, 
					   CONCAT(c.name, ' ', c.last_name) AS client,c.document_number AS cedula, 
					   COALESCE((SELECT last_reading 
								 FROM meter_readings 
								 WHERE meter_id = m.id 
								 ORDER BY id DESC 
								 LIMIT 1), 0) AS last_reading
				FROM $this->tableName m
				INNER JOIN clients c ON m.client_id = c.id";
	
		return $this->getDataAll($sql); 
	}*/
	
    //listar y mostrar en selct
    /*public function select(){
        $sql="SELECT * FROM $this->tableName";
        return  $this->getDataAll($sql); 
    }*/


}

