<?php

namespace App\Controllers;

use App\Models\Client;
use App\Models\Company;
use App\Models\Payment;
use App\Models\Reading;

class PaymentController extends Controller
{
	private $payment;

	public function __construct()
	{
		$this->payment = new Payment();
	}

	public function index(){
		return $this->view('payments.index',['title'=>'Pagos']);
	}

	public function guardaryeditar()
	{
		//$idusuario = $_SESSION["idusuario"];

		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$client_id = isset($_POST["idcliente"]) ? $_POST["idcliente"] : "";
		$date = isset($_POST["date"]) ? $_POST["date"] : "";
		$amount = isset($_POST["amount"]) ? $_POST["amount"] : "";
		$type = isset($_POST["type"]) ? $_POST["type"] : "";
		$transfer_number = isset($_POST['transfer_number']) ? $_POST['transfer_number'] : null;
		if (empty($id)) {
			$rspta = $this->payment->insertar($client_id, $date, $amount, $type, $transfer_number, $_POST["payment_id"], $_POST["amount_cost"]);
			//print_r($rspta);
			$mensaje = $rspta ? "Datos registrados correctamente" : "No se pudo registrar los datos";
			if ($rspta) {
				$respuesta = [
					"mensaje" => $mensaje,
					"idPayment" => $rspta,
				];
				return json_encode($respuesta);
			} else {
				$respuesta = [
					"mensaje" => $mensaje,
					"idPayment" => 0,
				];
				return json_encode($respuesta);
			}
		}
	}


	/*public function mostrar(){
		$rspta = $this->payment->mostrar($idventa);
		echo json_encode($rspta);
}*/

	public function anular()
	{
		$id = $_POST['id']??'';
		$rspta = $this->payment->anular($id);
		return $rspta ? "Datos anulados correctamente" : "No se pudo anular los datos";
	}

	public function listarDetalle()
	{
		$cnegocio = new Company();
		$rsptan = $cnegocio->listar();
		//$regn=$rsptan->fetch_object();
		if (empty($rsptan)) {
			$smoneda = 'Simbolo de moneda';
		} else {
			$smoneda = $rsptan[0]['simbolo'];
			$nom_imp = $rsptan[0]['nombre_impuesto'];
		};
		//recibimos el idventa
		$id = $_GET['id'];

		$rspta = $this->payment->listarDetalle($id);
		$total = 0;
		$subtotal = 0;
		$descuento = 0;

		echo '<thead style="background-color:#A9D0F5">
					<th style="text-align: center;">Servicio</th>
					<th style="text-align: center;">Cantidad</th>
					<th style="text-align: center;">Precio</th>
					<th style="text-align: center;">Descuento</th>
					<th style="text-align: center;">Subtotal</th>
				  </thead>';

		foreach ($rspta as $reg) {
			// Calcular el subtotal multiplicando precio por cantidad
			$subtotal += ($reg['precio'] * $reg['cantidad']);
			$descuento += $reg['descuento'];

			echo '<tr class="filas">
						<td>' . $reg['nombre'] . '</td>
						<td style="text-align: center;">' . $reg['cantidad'] . '</td> 
						<td style="text-align: center;">' . $reg['precio'] . '</td>
						<td style="text-align: center;">' . $reg['descuento'] . '</td>
						<td style="text-align: right;">' . $reg['subtotal'] . '</td>
					  </tr>';
			$total = $reg['total_venta'];
		}

		echo '<tfoot>
					<th><span>Subtotal</span><br><span>Descuento</span><br><span>TOTAL</span></th>
					<th></th>
					<th></th>
					<th></th>
					<th style="text-align: right;"><span id="total">' . $smoneda . ' ' . number_format((float)$subtotal, 2, '.', ',') . '</span><br>
						<span id="most_total" maxlength="4">' . $smoneda . ' ' . number_format((float)$descuento, 2, '.', ',') . '</span><br>
						<span id="most_total" maxlength="4">' . $smoneda . ' ' . number_format((float)$total, 2, '.', ',') . '</span>
					</th>
				  </tfoot>';
	}

	public function listar()
	{
		$rspta = $this->payment->listar();
		$data = array();
		$btn = '';
		foreach ($rspta as $reg) {
			$btn = $reg['status'] ? '<button title="Anular" class="btn btn-danger btn-sm" onclick="anular(' . $reg['id'] . ')"><i class="fas fa-trash"></i></button>' : '';
			$op = $reg['transfer_number'] ? '<strong> N°:' . $reg['transfer_number'] . '</strong>' : '';
			$urlt = 'report-voucher/ticket/';
			$opciones =  '<a target="_blank" href="' . $urlt . $reg['id'] . '"> <button title="Imprimir" class="btn btn-success btn-sm"><i class="fas fa-print"></i></button></a>';


			$data[] = array(
				"0" => $opciones . ' ' . $btn,
				"1" => $reg['date'],
				"2" => $reg['client'],
				"3" => $reg['amount'],
				"4" => '<strong>' . $this->numeroFactura($reg['id']) . ' </strong>',
				"5" => $reg['type'] . ' ' . $op,
				"6" => ($reg['status']) ? '<span class="badge bg-success">Aceptado</span>' : '<span class="badge bg-danger">Anulado</span>'
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		echo json_encode($results);
		exit;
	}

	function numeroFactura($numero)
	{
		$numero_factura = str_pad($numero, 9, '0', STR_PAD_LEFT);
		return  $numero_factura;
	}

	public function selectCliente()
	{

		$persona = new Client();

		$rspta = $persona->listarMedidor();
		echo '<option value="">seleccione...</option>';
		foreach ($rspta as $reg) {

			echo '<option value=' . $reg['id'] . '>' . $reg['name'] . ' ' . $reg['last_name'] . '</option>';
		}
	}


	public function listarLecturas()
	{
		$client_id = isset($_POST['meter_id']) ? $_POST['meter_id'] : 0;

		$rspta = $this->payment->pagosPendientes($client_id);
		$data = array();

		foreach ($rspta as $reg) {

			$data[] = array(
				"0" => '<button class="btn btn-success btn-sm" id="addetalle" name="' . $reg['id'] . '" onclick="agregarDetalle(' . $reg['id'] . ',' . $reg['date'] . ',' . '\''.$reg['description'].'\'' . ',' . $reg['amount'] . ')"><span class="fas fa-cart-plus"></span></button>',
				"1" => $reg['date'],
				"2" => $reg['description'],
				"3" => $reg['amount'],

			);
		}

		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		return json_encode($results);
	}

	public function paymentRegister(){
		return $this->view('payments.register',['title'=>'Registro de pagos']);
	}
}
