<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consulta de Facturas de Agua - AquaGestión</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome para iconos -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <link rel="stylesheet" href="<?php echo $_SERVER['BASE_URL'];?>assets/extensions/sweetalert2/sweetalert2.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@700;800&display=swap" rel="stylesheet">
    
        <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/ico">
        
    <link rel="stylesheet" href="<?php echo $_SERVER['BASE_URL'];?>assets/css/front/app.css">
    <link rel="stylesheet" href="<?php echo $_SERVER['BASE_URL'];?>assets/css/front/chat.css">

    <link rel="stylesheet" href="<?php echo $_SERVER['BASE_URL'];?>assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <!--<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">-->
    <link rel="stylesheet" href="<?php echo $_SERVER['BASE_URL'];?>assets/extensions/datatables.net-bs5/css/buttons.bootstrap5.min.css">
      <style>
            #preview {
      width: 80%;
      /* height: 15rem;*/
      margin: auto;
    }
      </style>
      <style>
            #medidores-container {
    transition: all 0.3s ease;
}

#select-medidor option {
    padding: 8px 12px;
}

#select-medidor option[disabled] {
    color: #6c757d;
}
</style>
</head>

<body>
    <!-- Header/Navbar -->
    <header>
        <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
            <div class="container">
                <a class="navbar-brand" href="<?php echo $_SERVER['BASE_URL'];?>">
                    <i class="fas fa-water"></i>AquaGestión
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link active" href="<?php echo $_SERVER['BASE_URL'];?>#inicio">Inicio</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo $_SERVER['BASE_URL'];?>consulta">Consulta</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo $_SERVER['BASE_URL'];?>#faq">Preguntas Frecuentes</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo $_SERVER['BASE_URL'];?>#contacto">Contacto</a>
                        </li>
                        <li class="nav-item">
                            <a class="btn btn-info text-white" href="<?php echo $_SERVER['BASE_URL'];?>login"><i class="fas fa-user"></i></a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
    </header>
    <main>
        <div class=" mt-5">
            <?= $content; ?>
        </div>
    </main>
    
    <!-- Botón de WhatsApp flotante -->
    <div class="whatsapp-btn" id="whatsappButton">
        <i class="fab fa-whatsapp"></i>
    </div>

    <!-- Chat de WhatsApp -->
    <div class="whatsapp-chat" id="whatsappChat">
        <div class="chat-header" id="chatHeader">
            <i class="fas fa-water"></i>
            <h5 class="mb-0">¿En qué te puedo ayudar?</h5>
        </div>
        <div class="chat-body">
            <div class="text-center text-muted small mb-3">
                Horario de atención: Lunes a Viernes 8am - 5pm
            </div>
            <div class="alert alert-info p-2 small">
                <i class="fas fa-info-circle me-2"></i>Responderemos en menos de 24 horas
            </div>
        </div>
        <div class="chat-footer">
            <form id="whatsappForm" class="d-flex">
                <textarea class="form-control me-2" id="whatsappMessage" rows="1" placeholder="Escribe tu mensaje..." required></textarea>
                <button type="submit" class="btn-send">
                    <i class="fas fa-paper-plane"></i>
                </button>
            </form>
        </div>
    </div>
    
    <!-- Footer -->
    <footer class="footer" id="contacto">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mb-5">
                    <h3 class="footer-title"><i class="fas fa-water me-2"></i>AquaGestión</h3>
                    <p class="mt-4">Sistema de gestión de cobros y consulta de facturas para asociaciones de agua potable. Simplificamos la administración del recurso hídrico en tu comunidad.</p>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="row">
                    <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                        <p class="mb-0">&copy; 2023 AquaGestión. Todos los derechos reservados.</p>
                    </div>
                    <div class="col-md-6 text-center text-md-end">
                        <p class="mb-0">
                            <a href="#" class="text-white-50 me-3">Términos</a>
                            <a href="#" class="text-white-50">Privacidad</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- DATATABLES -->
    <script src="<?php echo $_SERVER['BASE_URL'];?>assets/extensions/jquery/jquery.min.js"></script>
    <!--<script src="https://cdn.datatables.net/v/bs5/dt-1.12.1/datatables.min.js"></script>-->
    <!--<script src="assets/js/pages/datatables.js"></script>-->
    <script src="<?php echo $_SERVER['BASE_URL'];?>assets/js/datatables/datatables.min.js"></script>
    <script src="<?php echo $_SERVER['BASE_URL'];?>assets/js/datatables/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.colVis.min.js"></script>
        <script src="<?php echo $_SERVER['BASE_URL'];?>assets/extensions/sweetalert2/sweetalert2.min.js"></script>
    <script>
        var baseUrl = '<?php echo $_SERVER['BASE_URL']; ?>';
    </script>

    <!-- Carga dinámica de scripts según la vista -->
    <?php if (isset($currentView)): ?>
    <script src="<?php echo $_SERVER['BASE_URL'] . 'js/' . $currentView . '.js'; ?>?v=<?php echo time(); ?>"></script>
    <?php endif; ?>

    <script>

    </script>
</body>
</html>