    <!-- Consulta Section -->

    <section class="consulta-section" id="consulta">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="consulta-card">
                        <h2 class="section-title text-center">Consulta tu factura</h2>
                        <p class="section-subtitle text-center">Ingresa tu número de medidor o documento de identidad para ver tu información</p>

                        <form id="consultaForm">
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <label for="documento" class="form-label">Documento de identidad</label>
                                    <input type="text" class="form-control" id="documento" placeholder="Ej: 1234567890">
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label for="medidor" class="form-label">Número de medidor</label>
                                    <input type="text" class="form-control" id="medidor" placeholder="Ej: A123456">
                                </div>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-lg px-5">
                                    <i class="fas fa-search me-2"></i>Consultar
                                </button>
                                <button type="button" id="btn-limpiar" class="btn btn-secondary btn-lg px-5 ms-3">
                                    <i class="fas fa-broom me-2"></i>Limpiar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="container mb-4" id="medidores-container" style="display: none;">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-sm">
                    <div class="card-body text-center">
                        <label for="select-medidor" class="form-label fw-bold mb-3">Selecciona tu medidor</label>
                        <select class="form-select form-select-lg mb-3" id="select-medidor" aria-label="Selector de medidor">
                            <option value="" selected disabled>-- Selecciona un medidor --</option>
                            <!-- Las opciones se agregarán dinámicamente -->
                        </select>
                        <small class="text-muted">Selecciona el medidor que deseas consultar</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Resultados Section (oculto inicialmente) -->
    <section class="resultados-section" id="resultados" style="display: none;">
        <div class="container">
            <div class="row mb-4">
                <div class="col-12">
                    <h2 class="section-title">Tu información de consumo</h2>
                </div>
            </div>

            <div class="row mb-4">
                <!-- Tarjeta de Información del Cliente -->
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body text-center">
                            <h3 class="text-primary" id="cliente-nombre"></h3>
                            <p class="text-muted">Medidor: <span id="medidor-serie"></span></p>
                            <p><i class="fas fa-map-marker-alt text-primary me-2"></i> <span id="cliente-direccion"></span></p>
                        </div>
                    </div>
                </div>

                <!-- Tarjeta de Última Factura -->
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title text-center">Última Factura</h5>
                            <div class="text-center my-3">
                                <span class="badge bg-primary bg-gradient py-2 px-3 fs-6" id="factura-periodo"></span>
                            </div>
                            <p><strong>Consumo:</strong> <span id="factura-consumo"></span> m³</p>
                            <p><strong>Monto:</strong> $<span id="factura-monto"></span></p>
                            <!--<p><strong>Vencimiento:</strong> <span id="factura-vencimiento"></span></p>-->
                            <p><strong>Estado:</strong> <span id="factura-estado"></span></p>
                            <div class="text-center mt-3">
                                <button class="btn btn-sm btn-outline-primary" id="descargar-pdf">
                                    <i class="fas fa-download me-2"></i>Descargar PDF
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tarjeta de Estado de Cuenta -->
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body text-center">
                            <h5 class="card-title">Estado de Cuenta</h5>
                            <div class="display-4 my-3" id="cuenta-monto"></div>
                            <p id="cuenta-estado"></p>
                            <!--<button class="btn btn-primary w-100 mt-2" id="pagar-en-linea">
                                <i class="fas fa-credit-card me-2"></i>Pagar en línea
                            </button>-->
                        </div>
                    </div>
                </div>
            </div>

            <!-- Historial de Facturas con DataTables -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="consumo-chart">
                        <h5 class="mb-4"><i class="fas fa-history text-primary me-2"></i>Historial de Facturas</h5>
                        <div class="table-responsive">
                            <table id="historialFacturas" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Lectura Anterior</th>
                                        <th>Consumo (m³)</th>
                                        <th>Monto</th>
                                        <th>Estado</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Los datos se cargarán dinámicamente -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="consumo-chart">
                        <h5 class="mb-4"><i class="fas fa-history text-primary me-2"></i>Multas de reuniones</h5>
                        <div class="table-responsive">
                            <table id="historialMultas" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Reunión</th>
                                        <th>Descripción</th>
                                        <th>Monto</th>
                                        <th>Estado</th>
                                        <!--<th>Fecha Pago</th>-->
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Los datos se cargarán dinámicamente -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>