<?php
namespace App\Models;

use PDO;
use PDOException;

class Model
{

    protected $connection;
    protected $table;

    public function __construct()
    {
        $this->connect(); // Conecta a la base de datos
    }

    /**
     * Establece una conexión a la base de datos utilizando PDO.
     */
    private function connect()
    {
        $config = require __DIR__ . '/../../config/database.php';
        
        $dsn = "mysql:host={$config['host']};dbname={$config['database']};port={$config['port']};charset={$config['charset']}";
        
        try {
            $this->connection = new PDO(
                $dsn, 
                $config['username'], 
                $config['password']
            );
            $this->connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            throw new \RuntimeException(
                "Error de conexión a la base de datos: " . $e->getMessage()
            );
        }
    }

    public function beginTransaction()
    {
        return $this->connection->beginTransaction();
    }

    public function commit()
    {
        return $this->connection->commit();
    }

    public function rollBack()
    {
        return $this->connection->rollBack();
    }

    public function setData($sql, $arrData)
	{
		$query = $this->connection->prepare($sql);
		return $query->execute($arrData);
	}

	public function getReturnId($sql, $arrData)
	{
		$query = $this->connection->prepare($sql);
		$query->execute($arrData);
		return $this->connection->lastInsertId();
	}

	public function getDataAll($sql)
	{
		$execute = $this->connection->query($sql);
		return $execute->fetchAll(PDO::FETCH_ASSOC);
	}

	public function getData($sql, $arrData)
	{
		$query = $this->connection->prepare($sql);
		$query->execute($arrData);
		return $query->fetch(PDO::FETCH_ASSOC);
	}
}