<?php

namespace App\Models;
//incluir la conexion de base de datos
class Meter extends Model
{

	private $tableName = 'meters';

	//metodo insertar regiustro
	public function insertar($series, $location, $client_id, $zone_id)
	{
		$sql = "INSERT INTO $this->tableName (series,location,client_id,zone_id) VALUES (?,?,?,?)";
		$arrData = array($series, $location, $client_id, $zone_id);
		return $this->setData($sql, $arrData);
	}

	public function editar($id, $series, $location, $client_id, $zone_id)
	{
		$sql = "UPDATE $this->tableName SET series=?,location=?,client_id=?, zone_id = ? WHERE id=?";

		$arrData = array($series, $location, $client_id, $zone_id, $id);
		return $this->setData($sql, $arrData);
	}

	/*public function desactivar($id){
		$sql="UPDATE $this->tableName SET condicion='0' WHERE id=?";
		$arrData = array($id);
		return $this->setData($sql,$arrData);
	}*/

	/*public function activar($id){
		$sql="UPDATE $this->tableName SET condicion='1' WHERE id=?";
		$arrData = array($id);
		return $this->setData($sql,$arrData);
	}*/

	//metodo para mostrar registros
	public function mostrar(string $id)
	{
		$sql = "SELECT * FROM $this->tableName WHERE id=?";
		$arrData = array($id);
		return  $this->getData($sql, $arrData);
	}

	public function mostrarPorSerie(string $series)
	{
		$sql = "SELECT id, series,location,client_id FROM $this->tableName WHERE series=?";
		$arrData = array($series);
		return  $this->getData($sql, $arrData);
	}

	//listar registros
	public function listar()
	{
		$sql = "SELECT m.*, CONCAT(c.name, ' ', c.last_name) AS client, z.name AS barrio
        FROM $this->tableName m
        INNER JOIN clients c ON m.client_id = c.id INNER JOIN zones z ON m.zone_id = z.id";

		return  $this->getDataAll($sql);
	}

	public function mostrarPorCliente($clientId)
	{
		$sql = "SELECT m.*, CONCAT(c.name, ' ', c.last_name) AS client
        FROM $this->tableName m
        INNER JOIN clients c ON m.client_id = c.id WHERE m.client_id = '$clientId'";

		return  $this->getDataAll($sql);
	}

	public function listaReading($zone_id)
	{
		$sql = "SELECT m.*, 
					   CONCAT(c.name, ' ', c.last_name) AS client,c.document_number AS cedula,c.id AS client_id, 
					   COALESCE((SELECT last_reading 
								 FROM meter_readings 
								 WHERE meter_id = m.id 
								 ORDER BY id DESC 
								 LIMIT 1), 0) AS last_reading
				FROM $this->tableName m
				INNER JOIN clients c ON m.client_id = c.id";

		if (!empty($zone_id)) {
			$sql .= " WHERE m.zone_id = " . (int)$zone_id; // Seguro para IDs numéricos
		}

		return $this->getDataAll($sql);
	}

	//listar y mostrar en selct
	public function select()
	{
		$sql = "SELECT * FROM $this->tableName";
		return  $this->getDataAll($sql);
	}
}
