<?php

namespace App\Models;

class Attendance extends Model
{

	private $tableName = 'client_meeting';


	//metodo insertar regiustro
	public function insertar($client_id, $meeting_id, $attendance)
	{
		$sql = "INSERT INTO $this->tableName (client_id,meeting_id,attendance) VALUES (?,?,?)";
		$arrData = array($client_id, $meeting_id, $attendance);
		return $this->setData($sql, $arrData);
	}


	public function verificarLista($meeting_id)
	{
		$sql = "SELECT * FROM $this->tableName WHERE meeting_id=? ORDER BY id DESC LIMIT 1";
		$arrData = array($meeting_id);
		return  $this->getData($sql, $arrData);
	}

	public function editar($id, $tipo)
	{
		if (empty($id) || !is_numeric($id)) {
			return false;
		}
		$sw = true;
		$sql = "UPDATE $this->tableName SET attendance='$tipo' WHERE id=?";
		$arrData = array($id);
		return $this->setData($sql, $arrData);
	}

	public function editarQr($id, $tipo, $client_id)
	{
		if (empty($id) || !is_numeric($id)) {
			return false;
		}
		$sw = true;
		$sql = "UPDATE $this->tableName SET attendance='1' WHERE meeting_id=? AND client_id =?";
		$arrData = array($id, $client_id);
		return $this->setData($sql, $arrData);
	}
	public function editarAll($meeting_id, $tipo)
	{
		$sql = "UPDATE $this->tableName SET attendance='$tipo' WHERE meeting_id=?";
		$arrData = array($meeting_id);
		return $this->setData($sql, $arrData);
	}

	/*public function asignarMulta($amount,$meeting_id,$client_id){
		$sql="UPDATE client_meeting SET fine=?, fine_status=? WHERE client_id=? AND meeting_id=?";
		$arrData = array($amount,'Pendiente',$client_id,$meeting_id);
		return $this->setData($sql,$arrData);
	}*/
	public function asignarMultasBatch(array $multasData)
	{
		// Preparar la consulta base
		$sql = "UPDATE client_meeting SET fine = CASE ";

		// Construir las condiciones CASE para cada cliente
		$cases = [];
		$params = [];
		$ids = [];

		foreach ($multasData as $data) {
			$cases[] = "WHEN client_id = ? AND meeting_id = ? THEN ?";
			$params[] = $data['client_id'];
			$params[] = $data['meeting_id'];
			$params[] = $data['amount'];
			$ids[] = $data['client_id'];
		}

		$sql .= implode(' ', $cases);
		$sql .= " END, fine_status = 'Pendiente' WHERE (client_id, meeting_id) IN (";

		// Agregar los pares (client_id, meeting_id) para el WHERE
		$placeholders = [];
		foreach ($multasData as $data) {
			$placeholders[] = "(?, ?)";
			$params[] = $data['client_id'];
			$params[] = $data['meeting_id'];
		}

		$sql .= implode(', ', $placeholders) . ")";

		return $this->setData($sql, $params);
	}

	//metodo para mostrar registros
	public function mostrar(string $id)
	{
		$sql = "SELECT * FROM $this->tableName WHERE id=?";
		$arrData = array($id);
		return  $this->getData($sql, $arrData);
	}

	public function searchClient(string $document_number)
	{
		$sql = "SELECT * FROM clients WHERE document_number=?";
		$arrData = array($document_number);
		return  $this->getData($sql, $arrData);
	}

	//listar registros
	public function listar($id, $zone_id=null)
	{
		if($zone_id){
		$sql = "SELECT a.client_id, a.id,a.attendance, CONCAT(c.name,'-',c.last_name) AS customer, c.document_number,c.phone
        FROM $this->tableName a INNER JOIN clients c ON a.client_id=c.id INNER JOIN client_zones cz ON c.id = cz.client_id WHERE a.meeting_id='$id' AND cz.zone_id = '$zone_id'";
		}else{
		$sql = "SELECT a.client_id, a.id,a.attendance, CONCAT(c.name,'-',c.last_name) AS customer, c.document_number,c.phone
        FROM $this->tableName a INNER JOIN clients c ON a.client_id=c.id WHERE a.meeting_id='$id'";
		}


		return  $this->getDataAll($sql);
	}

}
