<?php

namespace App\Controllers;

use App\Models\Permissions;
use App\Models\User;
use App\Models\Zone;

class UserController extends Controller
{
	private $user;

	public function __construct()
	{
		$this->user = new User();
	}

	public function index()
	{
		$zone = new Zone();
		$zones = $zone->listar();
		return $this->view('users.index', ['title' => 'Usuarios','zones'=>$zones]);
	}

	public function guardaryeditar()
	{

		$idusuario = isset($_POST["idusuario"]) ? $idusuario = $_POST["idusuario"] : "";
		$nombre = isset($_POST["nombre"]) ? $nombre = $_POST["nombre"] : "";
		$tipo_documento = isset($_POST["tipo_documento"]) ? $tipo_documento = $_POST["tipo_documento"] : "";
		$num_documento = isset($_POST["num_documento"]) ? $num_documento = $_POST["num_documento"] : "";
		$direccion = isset($_POST["direccion"]) ? $direccion = $_POST["direccion"] : "";
		$telefono = isset($_POST["telefono"]) ? $telefono = $_POST["telefono"] : "";
		$email = isset($_POST["email"]) ? $email = $_POST["email"] : "";
		$cargo = isset($_POST["cargo"]) ? $cargo = $_POST["cargo"] : "";
		$zone_id = isset($_POST["zone_id"]) ? $zone_id = $_POST["zone_id"] : "";
		$login = isset($_POST["login"]) ? $login = $_POST["login"] : "";
		$clave = isset($_POST["clave"]) ? $clave = $_POST["clave"] : "";
		$imagen = isset($_POST["imagen"]) ? $imagen = $_POST["imagen"] : "";

if (!file_exists($_FILES['imagen']['tmp_name']) || !is_uploaded_file($_FILES['imagen']['tmp_name'])) {
    $imagen = empty($_POST["imagenactual"]) ? 'user-default.jpg' : $_POST["imagenactual"];
} else {
    // Eliminar imagen anterior si existe y no es la default
    if (!empty($_POST["imagenactual"]) && $_POST["imagenactual"] != 'user-default.jpg') {
        $old_image_path = __DIR__ . '/../assets/img/users/' . $_POST["imagenactual"];
        if (file_exists($old_image_path)) {
            unlink($old_image_path);
        }
    }

    // Validar tipo de imagen
    $allowed_types = ['image/jpg', 'image/jpeg', 'image/png'];
    if (in_array($_FILES['imagen']['type'], $allowed_types)) {
        $ext = pathinfo($_FILES["imagen"]["name"], PATHINFO_EXTENSION);
        $imagen = round(microtime(true)) . '.' . $ext;
        
        // Ruta absoluta para guardar
        $upload_dir = dirname(__DIR__, 2) . '/public/assets/img/users/';
        
        // Crear directorio si no existe
        if (!file_exists($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        
        $destination = $upload_dir . $imagen;
        
        if (move_uploaded_file($_FILES["imagen"]["tmp_name"], $destination)) {
            // Archivo subido correctamente
        } else {
            $imagen = 'user-default.jpg'; // Fallback si falla la subida
            // Puedes registrar el error: error_log("Error al mover archivo: " . $_FILES['imagen']['error']);
        }
    } else {
        $imagen = 'user-default.jpg'; // Tipo de archivo no permitido
    }
}

		//Hash SHA256 para la contraseña
		$clavehash = hash("SHA256", $clave);

		if (empty($idusuario)) {
			$rspta = $this->user->insertar($nombre, $tipo_documento, $num_documento, $direccion, $telefono, $email, $cargo,$zone_id, $login, $clavehash, $imagen, $_POST['permiso']);
			return $rspta ? "Datos registrados correctamente" : "No se pudo registrar todos los datos del user";
		} else {
			$rspta = $this->user->editar($idusuario, $nombre, $tipo_documento, $num_documento, $direccion, $telefono, $email, $cargo,$zone_id, $login, $imagen, $_POST['permiso']);
			return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
		}
	}

public function editarPerfil()
{
    $idusuario = $_POST["idusuario"] ?? "";
    $nombre = $_POST["nombre"] ?? "";
    $tipo_documento = $_POST["tipo_documento"] ?? "";
    $num_documento = $_POST["num_documento"] ?? "";
    $direccion = $_POST["direccion"] ?? "";
    $telefono = $_POST["telefono"] ?? "";
    $email = $_POST["email"] ?? "";
    $login = $_POST["login"] ?? "";
    $clave = $_POST["clave"] ?? "";
    $imagen = $_POST["imagen"] ?? "";
    $descripcion = $_POST["descripcion"] ?? "";
    $biografia = $_POST["biografia"] ?? "";

    // Configuración de directorio de uploads
    $upload_dir = dirname(__DIR__, 2) . '/public/assets/img/users/';
    
    // Verificar y crear directorio si no existe
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    // Manejo de la imagen
    if (!empty($_FILES['imagen']['tmp_name']) && is_uploaded_file($_FILES['imagen']['tmp_name'])) {
        // Eliminar imagen anterior si existe y no es la default
        if (!empty($_POST["imagenactual"]) && $_POST["imagenactual"] != 'user-default.jpg') {
            $old_image_path = $upload_dir . $_POST["imagenactual"];
            if (file_exists($old_image_path)) {
                unlink($old_image_path);
            }
        }

        // Validar tipo de imagen
        $allowed_types = ['image/jpg', 'image/jpeg', 'image/png'];
        $file_info = finfo_open(FILEINFO_MIME_TYPE);
        $mime_type = finfo_file($file_info, $_FILES['imagen']['tmp_name']);
        finfo_close($file_info);

        if (in_array($mime_type, $allowed_types)) {
            $ext = pathinfo($_FILES["imagen"]["name"], PATHINFO_EXTENSION);
            $imagen = uniqid('user_', true) . '.' . $ext;
            
            if (!move_uploaded_file($_FILES["imagen"]["tmp_name"], $upload_dir . $imagen)) {
                $imagen = $_POST["imagenactual"] ?? 'user-default.jpg';
                error_log("Error al mover la imagen: " . $_FILES['imagen']['error']);
            }
        } else {
            $imagen = $_POST["imagenactual"] ?? 'user-default.jpg';
            error_log("Tipo de archivo no permitido: " . $mime_type);
        }
    } else {
        $imagen = $_POST["imagenactual"] ?? 'user-default.jpg';
    }

    // Hash de la contraseña si se proporcionó
    if (!empty($clave)) {
        $clave = hash("SHA256", $clave);
    } else {
        // Mantener la contraseña actual si no se proporcionó una nueva
        $clave = null; // Asume que tu modelo manejará esto adecuadamente
    }

    $rspta = $this->user->editarPerfil(
        $idusuario, $nombre, $tipo_documento, $num_documento, 
        $direccion, $telefono, $email, $login, $clave, 
        $imagen, $descripcion, $biografia
    );
    
    return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
}

	public function desactivar()
	{
		$idusuario = isset($_POST["idusuario"]) ? $idusuario = $_POST["idusuario"] : "";
		$rspta = $this->user->desactivar($idusuario);
		return $rspta ? "Datos desactivados correctamente" : "No se pudo desactivar los datos";
	}

	public function activar()
	{
		$idusuario = isset($_POST["idusuario"]) ? $idusuario = $_POST["idusuario"] : "";
		$rspta = $this->user->activar($idusuario);
		return $rspta ? "Datos activados correctamente" : "No se pudo activar los datos";
	}

	public function mostrar()
	{
		$idusuario = isset($_POST["idusuario"]) ? $idusuario = $_POST["idusuario"] : "";
		$rspta = $this->user->mostrar($idusuario);
		return json_encode($rspta);
	}

	public function editar_clave()
	{
		$idusuarioc = isset($_POST["idusuarioc"]) ? $idusuarioc = $_POST["idusuarioc"] : "";
		$clavec = isset($_POST["clavec"]) ? $clavec = $_POST["clavec"] : "";
		$clavehash = hash("SHA256", $clavec);

		$rspta = $this->user->editar_clave($idusuarioc, $clavehash);
		return $rspta ? "Password actualizado correctamente" : "No se pudo actualizar el password";
	}


	public function listar()
	{
		$rspta = $this->user->listar();
		//declaramos un array
		$data = array();

		foreach ($rspta as $reg) {

			$botonDesactiva = '';
			if ($_SESSION['idusuario'] != $reg['idusuario']) {
				$botonDesactiva = '<button class="btn btn-danger btn-sm" onclick="desactivar(' . $reg['idusuario'] . ')"><i class="fas fa-user-times"></i></button>';
			}
			$data[] = array(
				"0" => ($reg['condicion']) ? '<button class="btn btn-warning btn-sm" onclick="mostrar(' . $reg['idusuario'] . ')"><i class="fas fa-user-edit"></i></button>' . ' ' . '<button class="btn btn-info btn-sm" onclick="mostrar_clave(' . $reg['idusuario'] . ')"><i class="fas fa-key"></i></button>' . ' ' . $botonDesactiva : '<button class="btn btn-warning btn-sm" onclick="mostrar(' . $reg['idusuario'] . ')"><i class="fas fa-user-edit"></i></button>' . ' ' . '<button class="btn btn-info btn-sm" onclick="mostrar_clave(' . $reg['idusuario'] . ')"><i class="fas fa-key"></i></button>' . ' ' . '<button class="btn btn-success btn-sm" onclick="activar(' . $reg['idusuario'] . ')"><i class="fas fa-user-check"></i></button>',
				"1" => $reg['nombre'],
				"2" => $reg['tipo_documento'],
				"3" => $reg['num_documento'],
				"4" => $reg['telefono'],
				"5" => $reg['email'],
				"6" => $reg['login'],
				"7" => $reg['barrio'],
				"8" => "<img alt='image' src='assets/img/users/" . $reg['imagen'] . "' height='50px' width='50px'>",
				"9" => ($reg['condicion']) ? '<span class="badge bg-success">Activo</span>' : '<span class="badge bg-danger">Inactivo</span>'
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		return json_encode($results);
	}

	public function permisos()
	{
		//obtenemos toodos los permisos de la tabla permisos
		$permiso = new Permissions();
		$rspta = $permiso->listar();

		//obtener permisos asigandos

		$id = isset($_POST["id"]) ? $id = $_POST["id"] : "";
		$marcados = $this->user->listarmarcados($id);
		//declaramos el array para almacenar todos los permisos marcados
		$valores = array();

		//almacenar permisos asigandos
		//$valores = array();
		foreach ($marcados as $per) {
			array_push($valores, $per['idpermiso']);
		}
		//mostramos la lista de permisos
		foreach ($rspta as $reg) {
			$sw = in_array($reg['idpermiso'], $valores) ? 'checked' : '';
			echo '<li>
			<div class="form-check form-switch"><input type="checkbox" ' . $sw . ' name="permiso[]" value="' . $reg['idpermiso'] . '" class="form-check-input" role="switch">
			<label class="form-check-label" for="flexSwitchCheckDefault">' . $reg['nombre'] . '</label>
			</div>
			</li>';
		}
	}

	public function profile(){
		return $this->view('users.profile',['title'=>'Perfil']);
	}
}
