<?php

namespace App\Controllers;

use App\Models\Attendance;
use App\Models\Client;
use App\Models\Company;
use App\Models\Meeting;
use App\Models\Payment;

class MeetingController extends Controller
{

	private $meeting;
	private $fine_amount;

	public function __construct()
	{
		$this->meeting = new Meeting();
		$company = new Company();
		$fine = $company->mostrar(1);
		$this->fine_amount = $fine['fine_meet'];
	}

	public function index()
	{
		return $this->view('meetings.index', ['title' => 'Reuniones']);
	}

	public function guardaryeditar()
	{

		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$date = isset($_POST["date"]) ? $_POST["date"] : "";
		$topic = isset($_POST["topic"]) ? $_POST["topic"] : "";

		if (empty($id)) {
			$rspta = $this->meeting->insertar($date, $topic);
			return $rspta ? "Datos registrados correctamente" : "No se pudo registrar los datos";
		} else {
			$rspta = $this->meeting->editar($id, $date, $topic);
			return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
		}
	}

	public function activar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$rspta = $this->meeting->activar($id);
		return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";

	}

	/*public function desactivar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$payment = new Payment();
		$attendance = new Attendance();
		$attendances = $attendance->listar($id);
		foreach($attendances as $at){
			if(!$at['attendance']){
				$attendance->asignarMulta($this->fine_amount,$id,$at['client_id']);
				$payment->insertarPago($at['client_id'], date('Y-m-d'), $this->fine_amount, $at['id'], 'client_meeting','Multa por inasistencia');
			}
		}

		$rspta = $this->meeting->desactivar($id);
		return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";

	}*/
	public function desactivar()
{
    $id = isset($_POST["id"]) ? $_POST["id"] : "";
    $payment = new Payment();
    $attendance = new Attendance();
    
    // Obtener todas las asistencias de una vez
    $attendances = $attendance->listar($id);
    
    // Preparar datos para inserción masiva
    $multasData = [];
    $pagosData = [];
    $today = date('Y-m-d');
    
    foreach($attendances as $at) {
        if(!$at['attendance']) {
            $multasData[] = [
                'amount' => $this->fine_amount,
                'meeting_id' => $id,
                'client_id' => $at['client_id']
            ];
            
            $pagosData[] = [
                'client_id' => $at['client_id'],
                'date' => $today,
                'amount' => $this->fine_amount,
                'reference_id' => $at['id'],
                'reference_table' => 'client_meeting',
                'description' => 'Multa por inasistencia'
            ];
        }
    }
    
    // Procesar multas y pagos en lotes
    if (!empty($multasData)) {
        $attendance->asignarMultasBatch($multasData);
        $payment->insertarPagosBatch($pagosData);
    }
    
    $rspta = $this->meeting->desactivar($id);
    return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
}

	public function mostrar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$rspta = $this->meeting->mostrar($id);
		return json_encode($rspta);
	}

	public function listar()
	{
		$fechaActual = date('Y-m-d');
		$rspta = $this->meeting->listar();
		$data = array();

		foreach ($rspta as $reg) {
			$opcion=$reg['status']?'<button class="btn btn-danger btn-sm" onclick="desactivar(' . $reg['id'] .')"><i class="fas fa-times"></i> Finalizar</button>':'<button class="btn btn-success btn-sm" onclick="activar(' . $reg['id'] . ')"><i class="fas fa-check"></i></button>';
			$estado = ($reg['status']) ? '<span class="badge bg-warning">Pendiente</span>' : '<span class="badge bg-success">Finalizado</span>';
			$data[] = array(
				"0" => '<button class="btn btn-warning btn-sm" onclick="mostrar(' . $reg['id'] . ')"><i class="fas fa-pencil-alt"></i></button>'.' '.$opcion,
				"1" => $reg['date'],
				"2" => $reg['topic'],
				"3" => '<a href="attendances/' . $reg['id'] . '" class="btn btn-info btn-sm"><i class="fas fa-clock"></i></a>',
				"4" => $estado,
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		return json_encode($results);
	}
}
