<div class="page-content">
    <section class="section">
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex flex-column flex-md-row justify-content-between align-items-center">
                            <h4 class="card-title">Lectura de Medidores</h4>
                            <div class="btn-group flex-column flex-md-row md-w-100 w-md-auto">
                                <button class="btn btn-primary mb-2 mb-md-0 mr-md-2 " type="button" onclick="verMedidores()">
                                    <i class="fa fa-search mr-1"></i> Buscar Medidor
                                </button>
                                <button class="btn btn-info " type="button" onclick="iniciarLecturaQr()">
                                    <i class="fa fa-qrcode mr-1"></i> Escanear QR
                                </button>
                            </div>
                        </div>

                        <div class="card-body">
                            <!-- FORMULARIO DE REGISTRO -->
                            <div id="formularioregistros">
                                <form name="formulario" id="formulario" method="POST">
                                    <div class="row">
                                        <!-- Sección de información del medidor -->
                                        <div class="col-md-12 mb-4">
                                            <div class="card border-left-primary shadow h-100 py-2">
                                                <div class="card-body">
                                                    <h5 class="card-title text-primary">
                                                        <i class="fas fa-tachometer-alt mr-2"></i>Información del Medidor
                                                    </h5>
                                                    <div class="row no-gutters align-items-center">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="series">Serie del Medidor</label>
                                                                <input type="hidden" name="id" id="id">
                                                                <input type="hidden" name="idMedidor" id="idMedidor">
                                                                <input class="form-control" type="text" name="series" id="series" readonly required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-8">
                                                            <div class="form-group">
                                                                <label for="cliente">Socio</label>
                                                                <input type="hidden" id="client_id" name="client_id">
                                                                <input class="form-control" type="text" name="cliente" id="cliente" readonly required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Sección de tarifas -->
                                        <div class="col-md-12 mb-4">
                                            <div class="card border-left-info shadow h-100 py-2">
                                                <div class="card-body">
                                                    <h5 class="card-title text-info">
                                                        <i class="fas fa-money-bill-wave mr-2"></i>Detalles de Tarifas
                                                    </h5>
                                                    <div class="row text-center">
                                                        <div class="col-md-4 p-2">
                                                            <div class="p-3 bg-light rounded">
                                                                <strong>Máximo Cúbico</strong>
                                                                <div class="h5 text-primary" id="max_cubico">-</div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 p-2">
                                                            <div class="p-3 bg-light rounded">
                                                                <strong>Precio Fijo</strong>
                                                                <div class="h5 text-success" id="precio_fijo">-</div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 p-2">
                                                            <div class="p-3 bg-light rounded">
                                                                <strong>Precio por Cúbico</strong>
                                                                <div class="h5 text-warning" id="precio_cubico">-</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Sección de lecturas -->
                                        <div class="col-md-12">
                                            <div class="card border-left-success shadow h-100 py-2">
                                                <div class="card-body">
                                                    <h5 class="card-title text-success">
                                                        <i class="fas fa-file-invoice-dollar mr-2"></i>Registro de Lectura
                                                    </h5>
                                                    <div class="row">


                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="previus_reading">Última Lectura</label>
                                                                <div class="input-group">
                                                                    <input class="form-control" type="number" name="previus_reading" id="previus_reading" readonly required>
                                                                    <div class="input-group-append">
                                                                        <span class="input-group-text">m³</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group text-danger">
                                                                <label for="last_reading">Lectura Actual</label>
                                                                <div class="input-group">
                                                                    <input class="form-control" type="number" name="last_reading" id="last_reading" step="0.001" placeholder="0" required>
                                                                    <div class="input-group-append">
                                                                        <span class="input-group-text">m³</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="consumption">Consumo</label>
                                                                <div class="input-group">
                                                                    <input class="form-control" type="number" name="consumption" id="consumption" step="0.001" readonly required>
                                                                    <div class="input-group-append">
                                                                        <span class="input-group-text">m³</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group text-danger">
                                                                <label for="type">Tipo de Lectura</label>
                                                                <select class="form-select" name="type" id="type" required>
                                                                    <option value="Mensual">Mensual</option>
                                                                    <option value="Bimestral">Bimestral</option>
                                                                    <option value="Trimestral">Trimestral</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label for="total_cost">Total a Pagar</label>
                                                                <div class="input-group">
                                                                    <div class="input-group-prepend">
                                                                        <span class="input-group-text">$</span>
                                                                    </div>
                                                                    <input class="form-control" type="number" name="total_cost" id="total_cost" step="0.01" readonly required>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row mt-4">
                                                        <div class="col-12">
                                                            <div class="d-flex flex-column flex-md-row justify-content-md-start gap-2">
                                                                <button class="btn btn-primary" type="submit" id="btnGuardar">
                                                                    <i class="fa fa-save mr-1"></i> Guardar
                                                                </button>
                                                                <a href="<?php echo $_SERVER['BASE_URL']; ?>meter-reading" class="btn btn-danger">
                                                                    <i class="fa fa-times mr-1"></i> Cancelar
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </form>
                            </div>
                            <!-- FIN FORMULARIO DE REGISTRO -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Modal para escanear QR -->
<div class="modal fade" id="mdlQRMedidor" tabindex="-1" role="dialog" aria-labelledby="qrModalLabel" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="qrModalLabel">
                    <i class="fa fa-qrcode mr-2"></i>Escaneo de Código QR
                </h5>
            </div>
            <div class="modal-body">
                <div class="row justify-content-center">
                    <div class="col-md-8 text-center">
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle mr-2"></i>Encuadre el código QR del medidor dentro del área delimitada
                        </div>

                        <div class="border border-primary p-2 rounded" style="background-color: #f8f9fa;">
                            <video id="preview" class="w-100" style="max-height: 400px;"></video>
                        </div>

                        <div class="mt-3">
                            <button type="button" id="btnApagaCamara" onclick="$('#mdlQRMedidor').modal('hide')" class="btn btn-warning">
                                <i class="fa fa-power-off mr-1"></i> Apagar Cámara
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para listar medidores -->
<?php include 'includes/clients-modal.php' ?>