var tabla;

//funcion que se ejecuta al inicio
function init() {
	mostrarform(false);
	mostrarform_clave(false);
	listar();
	$("#formularioc").on("submit", function (c) {
		editar_clave(c);
	});
	$("#formulario").on("submit", function (e) {
		guardaryeditar(e);
	});

	//$("#imagenmuestra").hide();
	//mostramos los permisos
	$.post("users/permisos",{id:null}, function (r) {
		$("#permisos").html(r);
	});


	$("#imagenmuestra").attr("src", "assets/img/users/user-default.jpg");
	$("#previewImagen").hide();
}

/*$("#imagen").filestyle({
	badge: true,
	input: false,
	text: " Seleccionar imagen",
	//placeholder: " Selecciona una imagen",
	btnClass: "btn-info",
	htmlIcon: '<span class="far fa-folder-open"></span> ',
});*/

//VISTA PREVIA DE LA IMAGEN
function readURL(input) {
	let imgActual = $("#imagenactual").val();
	if (input.files && input.files[0]) {
		var reader = new FileReader();
		reader.onload = function (e) {
			$("#imagenmuestra").attr("src", e.target.result);
		};
		reader.readAsDataURL(input.files[0]);
		$("#previewImagen").show();
	} else {
		if ($("#modoEdicion").val() === "true") {

			if (imgActual) {
				$("#imagenmuestra").attr("src", "assets/img/users/" + imgActual);
				//alert("Selecione archivo para ver");
			}
		} else {
			$("#imagenmuestra").attr("src", "assets/img/users/user-default.jpg");
		}

	}
}

$("#imagen").change(function () {
	readURL(this);
});

//MOSTRAR LA OPCION DE QUITAR LA IMAGEN
$("#previewImagen").click(function () {
	//$(":file").filestyle("clear");
	$("#imagen").val("");
	//$(":file").filestyle("destroy");
	readURL($("#imagen"));
	//$("#imagenmuestra").attr("src", "assets/img/products/default.png");
	$("#previewImagen").hide();
});

//funcion limpiar
function limpiar() {
	$("#nombre").val("");
	$("#num_documento").val("");
	$("#direccion").val("");
	$("#telefono").val("");
	$("#email").val("");
	$("#cargo").val("");
	$("#login").val("");
	$("#clave").val("");
	//$("#imagenmuestra").attr("src", "");
	$("#imagenactual").val("");
	$("#idusuario").val("");
	//$(":file").filestyle("clear");
	$("#imagen").val("");
	$("#previewImagen").hide();
}

//funcion mostrar formulario
function mostrarform(flag) {
	limpiar();
	if (flag) {
		$("#listadoregistros").hide();
		$("#formularioregistros").show();
		$("#btnGuardar").prop("disabled", false);
		$("#btnagregar").hide();
	} else {
		$("#listadoregistros").show();
		$("#formularioregistros").hide();
		$("#btnagregar").show();
	}
}
function mostrarform_clave(flag) {
	limpiar();
	if (flag) {
		$("#listadoregistros").hide();
		$("#formulario_clave").show();
		$("#btnGuardar_clave").prop("disabled", false);
		$("#btnagregar").hide();
	} else {
		$("#listadoregistros").show();
		$("#formulario_clave").hide();
		$("#btnagregar").show();
	}
}
//cancelar form
function cancelarform() {
	$("#claves").show();
	limpiar();
	mostrarform(false);
	$("#modoEdicion").val("false");
	$("#imagenmuestra").attr("src", "assets/img/users/user-default.jpg");
}
function cancelarform_clave() {
	limpiar();
	mostrarform_clave(false);
}
//funcion listar
function listar() {
	tabla = $("#tbllistado")
		.dataTable({
			language: {
				decimal: "",
				emptyTable: "No hay información",
				info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
				infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
				infoFiltered: "(Filtrado de _MAX_ total entradas)",
				infoPostFix: "",
				thousands: ",",
				lengthMenu: "Mostrar _MENU_ Entradas",
				loadingRecords: "Cargando...",
				processing: "Procesando...",
				search: "Buscar:",
				zeroRecords: "Sin resultados encontrados",
				paginate: {
					first: "Primero",
					last: "Ultimo",
					next: "Siguiente",
					previous: "Anterior",
				},
			},
			language: {
				search: "Buscar:",
				zeroRecords: "No se encontró nada, lo siento",
				info: "mostrando de _START_ a _END_ de _TOTAL_ elementos",
				infoEmpty: "No hay registros disponibles",
				paginate: {
					previous: "Anterior",
					next: "Siguiente",
				},
			},
			aProcessing: true, //activamos el procedimiento del datatable
			aServerSide: true, //paginacion y filrado realizados por el server
			dom: "Bfrtip", //definimos los elementos del control de la tabla
			buttons: [
				{
					extend: "excelHtml5",
					text: "Excel",
					titleAttr: "Exportar a Excel",
					title: "Reporte de Usuarios",
					sheetName: "Usuarios",
					exportOptions: {
						columns: [1, 2, 3, 4, 5, 6, 8],
					},
				},
				{
					extend: "pdfHtml5",
					text: '<i class="fa fa-file-pdf-o"></i> PDF',
					titleAttr: "Exportar a PDF",
					title: "Reporte de Usuarios",
					//messageTop: "Reporte de usuarios",
					pageSize: "A4",
					download: "open",
					//orientation: 'landscape',
					exportOptions: {
						columns: [1, 2, 3, 4, 5, 6, 8],
					},
				},
			],
			ajax: {
				url: "users/listar",
				type: "get",
				dataType: "json",
				error: function (e) {
					console.log(e.responseText);
				},
			},
			bDestroy: true,
			iDisplayLength: 10, //paginacion
			order: [[0, "desc"]], //ordenar (columna, orden)
		})
		.DataTable();
}
//funcion para guardaryeditar
function guardaryeditar(e) {
	e.preventDefault(); //no se activara la accion predeterminada
	$("#btnGuardar").prop("disabled", true);
	var formData = new FormData($("#formulario")[0]);

	$.ajax({
		url: baseUrl+"users/guardaryeditar",
		type: "POST",
		data: formData,
		contentType: false,
		processData: false,

		success: function (datos) {
			var tabla = $("#tbllistado").DataTable();
			Swal.fire({
				title: "Registro",
				text: datos,
				icon: "info",
			}),
				mostrarform(false);
			tabla.ajax.reload();
		},
	});
	$("#claves").show();
	limpiar();
}

function editar_clave(c) {
	c.preventDefault(); //no se activara la accion predeterminada
	$("#btnGuardar_clave").prop("disabled", true);
	var formData = new FormData($("#formularioc")[0]);

	$.ajax({
		url: baseUrl+"users/editar_clave",
		type: "POST",
		data: formData,
		contentType: false,
		processData: false,

		success: function (datos) {
			var tabla = $("#tbllistado").DataTable();
			Swal.fire({
				title: "Registro",
				text: datos,
				icon: "info",
			}),
				mostrarform_clave(false);
			tabla.ajax.reload();
		},
	});

	limpiar();
}
function mostrar(idusuario) {
	$("#modoEdicion").val("true");
	var miInput = $("#imagen");
	readURL(miInput);
	$.post(
		"users/mostrar",
		{ idusuario: idusuario },
		function (data, status) {
			data = JSON.parse(data);
			mostrarform(true);
			console.log($("#idusuario").val(data.idusuario).length);
			if ($("#idusuario").val(data.idusuario).length === 0) {
				$("#claves").show();
			} else {
				$("#claves").hide();
			}
			$("#nombre").val(data.nombre);
			$("#tipo_documento").val(data.tipo_documento);
			//$("#tipo_documento").select2();
			//$("#tipo_documento").empty();
			//$("#tipo_documento").select2({
			//data: data.slots,
			//});
			$("#num_documento").val(data.num_documento);
			$("#direccion").val(data.direccion);
			$("#telefono").val(data.telefono);
			$("#email").val(data.email);
			$("#cargo").val(data.cargo);
			$("#zone_id").val(data.zone_id);
			$("#login").val(data.login);

			$("#imagenmuestra").show();
			$("#imagenmuestra").attr("src", "assets/img/users/" + data.imagen);
			$("#imagenactual").val(data.imagen);
			$("#idusuario").val(data.idusuario);
		}
	);
	$.post("users/permisos",{id:idusuario}, function (r) {
		$("#permisos").html(r);
	});
}

function mostrar_clave(idusuario) {

	mostrarform_clave(true);
	$("#clavec").val("");
	$("#idusuarioc").val(idusuario);
}

//funcion para desactivar
function desactivar(idusuario) {

	Swal.fire({
		title: "Desactivar?",
		text: "Esá seguro de desactivar?",
		icon: 'warning',
		showCancelButton: true,
		//confirmButtonColor: '#3085d6',
		//cancelButtonColor: '#d33',
		confirmButtonText: 'Si, desactivar!',
		cancelButtonText: 'Cancelar'
	}).then((result) => {
		if (result.isConfirmed) {
			$.post(
				"users/desactivar",
				{ idusuario: idusuario },
				function (e) {
					Swal.fire(
						e,
						"Desactivado!",
						"success", {
					});
					var tabla = $("#tbllistado").DataTable();
					tabla.ajax.reload();
				}
			);
		}
	});

}

function activar(idusuario) {
	Swal.fire({
		title: "Activar?",
		text: "Esá seguro de activar?",
		icon: 'warning',
		showCancelButton: true,
		//confirmButtonColor: '#3085d6',
		//cancelButtonColor: '#d33',
		confirmButtonText: 'Si, activar!',
		cancelButtonText: 'Cancelar'
	}).then((result) => {
		if (result.isConfirmed) {
			$.post(
				"users/activar",
				{ idusuario: idusuario },
				function (e) {
					Swal.fire(e,
						"Activado!",
						"success", {

					});
					var tabla = $("#tbllistado").DataTable();
					tabla.ajax.reload();
				}
			);
		}
	});
}

init();
