<?php

namespace App\Controllers;

use App\Models\Zone;

//require_once dirname(__FILE__, 2) . '/Config/config.php';
//date_default_timezone_set(ZONA_HORARIA);
/*require_once "../Models/Zone.php";
if (strlen(session_id()) < 1)
	session_start();*/


class ZoneController extends Controller
{
	private  $zone;

	public function __construct()
	{
		$this->zone = new Zone();
	}

	public function index()
	{
		return $this->view('zones.index', ['title' => 'Barrios']);
	}

	public function guardaryeditar()
	{

		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$name = isset($_POST["name"]) ? $_POST["name"] : "";
		if (empty($id)) {
			$rspta = $this->zone->insertar($name);
			return $rspta ? "Datos registrados correctamente" : "No se pudo registrar los datos";
		} else {
			$rspta = $this->zone->editar($id, $name);
			return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
		}
	}


	public function mostrar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$rspta = $this->zone->mostrar($id);
		return json_encode($rspta);
	}

	public function listar()
	{
		$rspta = $this->zone->listar();
		$data = array();


		foreach ($rspta as $reg) {
			$data[] = array(
				"0" => '<button class="btn btn-warning btn-sm" onclick="mostrar(' . $reg['id'] . ')"><i class="fas fa-pencil-alt"></i></button>',
				"1" => $reg['id'],
				"2" => $reg['name']
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		return json_encode($results);
	}

	public function selectZone()
	{
		$rspta = $this->zone->select();
		echo '<option value="">Seleccione...</option>';
		foreach ($rspta as $reg) {
			echo '<option value="' . $reg['id'] . '">' . $reg['name'] . '</option>';
		}
	}
}
