﻿package 
{
	import adobe.utils.*;
	import fl.controls.*;
	import fl.video.*;
	import flash.accessibility.*;
	import flash.display.*;
	import flash.errors.*;
	import flash.events.*;
	import flash.external.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.media.*;
	import flash.net.*;
	import flash.printing.*;
	import flash.system.*;
	import flash.text.*;
	import flash.ui.*;
	import flash.utils.*;
	import flash.xml.*;

	import com.everydayflash.equalizer.*;
	import com.everydayflash.equalizer.color.*;

	import com.aacplayer.TimerDisplay;
	import com.aacplayer.StationStatus;
	import com.aacplayer.ArtistImage;	
	
	import com.aacplayer.addons.Knob;
	import com.aacplayer.addons.Visualization;
	
	import com.anttikupila.soundSpectrum.SoundProcessor;
	import com.anttikupila.revolt.presets.*;		
	import com.caurina.transitions.Tweener;	
	
	public class DestructorUNL extends flash.display.MovieClip
	{
		public var metaDataText:flash.text.TextField;
		public var labletxt:flash.text.TextField;
		public var Station:flash.text.TextField;		
		public var nowPlayingScroller:flash.display.MovieClip
		public var maskClip:flash.display.MovieClip;
		public var btnPlayPause:flash.display.MovieClip;
		public var btnStop:flash.display.MovieClip;
		public var sCaption:TextField;
		public var livestatus:TextField;
		
		public var Title:flash.text.TextField;
		public var Listeners:flash.text.TextField;
		public var Bitrate:flash.text.TextField;
		public var movieName:flash.text.TextField;
		public var serverName:flash.text.TextField;
		public var stationName:flash.text.TextField;
		
		private var timerDisp:TimerDisplay;
		private var clockDisp:Timer;
		private var reconnectTimer:Timer;
		private var knob:Knob;
		private var visualization:Visualization;
		private var stationStatus:StationStatus = new StationStatus();
		private var artistImage:ArtistImage; 
		private var ArtistName:String;
		private var SongTitle:String;
		
		
		private var UrlStatusScriptLink:String;

		private var tmrduration:String;
		private var labelText:String;

		private var equalizerSettings:EqualizerSettings = new EqualizerSettings();
		private var equalizer:Equalizer = new Equalizer();
		private var uid:String;
		private var uniqueid:String;
		
		private var xmlLoader:URLLoader;
		private var xmlData:XML;

		private var LogoURLRequest:flash.net.URLRequest;

		private var isConnected:Boolean;
		private var isTryingtoConnect:Boolean;
		private var isPaused:Boolean;		
		private var isDebugMode:Boolean;
		private var widthPos:Number;
		private var bounds:flash.geom.Rectangle;
		private var xPos:Number;
		private var myLoader:flash.display.Loader;
		private var connect:flash.display.MovieClip;
		private var banLoader:flash.display.Loader;
		
		private var maxPos:Number;
		private var minPos:Number;
		private var scrollingSpeed:Number;
		private var minScrollerTextLength:Number;
		private var isDirectionLeft:Boolean;
		
		private var soundVolume:flash.media.SoundTransform;
		private var metaDataValues:Array;
		private var banURLRequest:flash.net.URLRequest;
		private var heightPos:Number;

		private var netStream:NetStream = null;
		private var netConnection:NetConnection = null;

		private var rtmpserver:String;

		private var sp:SoundProcessor;
		private var gfx:BitmapData;
		private var presetList:Array;
		private var presetInt:Timer;
		private var preset:Preset;
		private var lastChange:Number;	
		
		var loader:URLLoader = new URLLoader();
		
		public function DestructorUNL()
		{
			super();
			addFrameScript(0, mainFrame);
			return;
		}

		function mainFrame():*
		{
			initialize();
			return;
		}
				
		private function initialize():void
		{
			isPaused = false;			
			isDebugMode = false;
			
			initSecuritySettings();			
			initContextMenu();
			initVolumeControl();
			initXMLLoader();
			initVisualization();
			initEqualizer();
			initSoundProcessor();
			initStatusTimer();
			initClock();
			initReconnect();
			initMetaData();
			initTileScrolling();
			initButtons();
			initArtistImage();			
		}
		
		private function initSecuritySettings():void
		{
			Security.allowDomain("*");
		}
		
		private function initContextMenu():void
		{
			var my_menu:ContextMenu = new ContextMenu();
			my_menu.hideBuiltInItems();
			var my_notice = new ContextMenuItem("AAC+ Radio Player");
			var my_email = new ContextMenuItem("Streaming507.com");
			my_email.separatorBefore = true;
			my_notice.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, openLink);
			function openLink(e:ContextMenuEvent):void
			{
				navigateToURL(new URLRequest("http://www.streaming507.com/"));
			}

			my_menu.customItems.push(my_notice, my_email);
			contextMenu = my_menu;
		}		
		
		private function initVisualization():void
		{
			//visualization = new Visualization(400,200);
			//visualization.enabled = true;
			//addChild( visualization );
			
	
		}
		
		private function initVolumeControl():void
		{
			//knob
			knob = new Knob("Volume",0,1,.9,"",15,0.001);
			knob.addEventListener( Event.CHANGE, knobChangeHandler );
			knob.x = 260;
			knob.y = 190;
			addChild( knob );

			function knobChangeHandler( event : Event ):void
			{
				//trace(event.target.value);
				if (netStream)
				{
					soundVolume.volume = event.target.value;
					netStream.soundTransform = soundVolume;
				}
			}			
		}		
		
		private function initXMLLoader():void
		{
			var isLocal:Boolean = Capabilities.playerType == "External";  
			var randomParam:String="";
			var playerpath:String="";
			if(!isLocal) {
				randomParam="?r=" + Math.round(Math.random() * 999);
				playerpath=root.loaderInfo.parameters.playerpath;
				if(playerpath==null) playerpath="";
			}
			
			xmlLoader = new URLLoader();
			xmlLoader.load(new URLRequest(playerpath + "configDestructorUNL.xml" + randomParam));	
			xmlLoader.addEventListener(Event.COMPLETE, LoadXML);		
		}		
		
		private function initEqualizer():void
		{	
			equalizerSettings.numOfBars = 46;
			equalizerSettings.height = 78;
			equalizerSettings.barSize = 6;
			equalizerSettings.vgrid = true;
			equalizerSettings.hgrid = 4;
            equalizerSettings.colorManager = new GradientBarColor(0xFF9900,0x01DF01);
			equalizerSettings.effect = EqualizerSettings.FX_REFLECTION;

			equalizer.update(equalizerSettings);
			equalizer.x = 50;
			equalizer.y = 53;
			addChildAt(equalizer,4);
		}
		
		private function initStatusTimer():void
		{		
			livestatus.text = "OFFLINE";
			soundVolume = new flash.media.SoundTransform();

			timerDisp = new TimerDisplay(100);
			timerDisp.addEventListener("TIMER_COUNT",diptimer);

			function diptimer(e:Event):void
			{
				tmrduration = timerDisp.getTimeLapse();
				labletxt.text = tmrduration + " " + labelText;
				livestatus.text = "EN VIVO";
			}
		}
		
		private function initClock():void
		{
			clockDisp = new Timer(1000);
			clockDisp.addEventListener(TimerEvent.TIMER, clocktimer);
			clockDisp.start();
			function clocktimer(e:Event):void
			{
				var timedate = new Date();
				var clockH = timedate.getHours();
				var clockM = timedate.getMinutes();
				var clockS = timedate.getSeconds();
				if (clockH < 10)
				{
					clockH = "0" + clockH;
				}
				if (clockM < 10)
				{
					clockM = "0" + clockM;
				}
				if (clockS < 10)
				{
					clockS = "0" + clockS;
				}
				Station.text = clockH + ": " + clockM + ": " + clockS;
			}
		}
		
		private function initReconnect():void
		{
			reconnectTimer = new Timer(5000);
			reconnectTimer.addEventListener(TimerEvent.TIMER, reconnectEvent);
			reconnectTimer.start();
			function reconnectEvent(e:Event):void
			{
				if (isTryingtoConnect && !isConnected)
				{
					labletxt.text = "Reconnecting...";
					doStop();
					doConnect();
				}

				if (netStream)
				{
					//sBytesLoaded.text="loaded: " + netStream.bytesLoaded;
				}
			}
		}
		
		private function initSoundProcessor()
		{
			sp = new SoundProcessor();
			gfx = new BitmapData(335, 190, false, 0x000000)
			var pic:Bitmap = new Bitmap(gfx);
			addChildAt(pic,3);
			pic.x=12;
			pic.y=136;
			presetList = new Array(  new LineSmooth(), new LineSmooth(), new LineSmooth());
			//presetList = new Array(new LineFourier(), new LineNoFourier(), new Explosion(), new LineSmooth(), new LineWorm(), new Tunnel());

			var initialDelay:Timer = new Timer(7100, 1);
			initialDelay.addEventListener(TimerEvent.TIMER, setupTimer);
			initialDelay.start();
			// initialize
			nextPreset(null);
		}
		// ------------------- spectrum --------------------------------------------	
		private function compute(ev:Event):void {
			var soundArray:Array = sp.getSoundSpectrum(preset.fourier);
			preset.applyGfx(gfx, soundArray);
		}		
		private function setupTimer(ev:Event):void {
			presetInt = new Timer(12950, 0);
			presetInt.addEventListener(TimerEvent.TIMER, nextTimedPreset);
			presetInt.start();
			nextPreset(null);
		}
		
		private function nextPreset(ev:Event):void {
			var index:uint = Math.floor(Math.random()*presetList.length);
			var newPreset:Preset = presetList[index];
			if (newPreset != preset) {
				preset = newPreset;
				preset.init();
				//trace("next effect is '" + preset.toString().toLowerCase() + "'");
			} else {
				nextPreset(null);
			}
			lastChange = getTimer();
		}
		
		private function nextTimedPreset(ev:Event):void {
			if (getTimer() - lastChange > 5000) {
				nextPreset(ev);
			}
		}		
		
		
		
		private function initMetaData():void
		{			
			metaDataValues = new Array();
			metaDataValues["artist"] = "";
			metaDataValues["title"] = "";
			metaDataValues["genre"] = "";
			metaDataValues["name"] = "";
			metaDataValues["url"] = "";
		}
		
		private function initTileScrolling():void
		{
			maxPos = 0;
			minPos = 0;
			scrollingSpeed = 1;
			minScrollerTextLength = maskClip.width;
			isDirectionLeft = true;
			nowPlayingScroller.nowPlaying.multiline = false;
			nowPlayingScroller.mask = maskClip;
			nowPlayingScroller.nowPlaying.autoSize = "right";
			//nowPlayingScroller.addEventListener(Event.ENTER_FRAME, nowPlayingUpdater);
		}
		
		private function initButtons():void
		{
			btnPlayPause.addEventListener(flash.events.MouseEvent.CLICK, btnPlayPausePauseClick);
			btnStop.addEventListener(flash.events.MouseEvent.CLICK, btnStopClick);
		}

		private function initArtistImage():void
		{
			artistImage = new ArtistImage(80,80,"b5289a6c53b2be0961efb71d78d70820");
			addChild(artistImage);
			artistImage.x=22;
			artistImage.y=26;
		}
		
		
		private function updateStationStatus(e:Event):void
		{
			Listeners.text = "Listeners "+ stationStatus.ListenerCount;
			Bitrate.text = "Bitrate "+ stationStatus.Bitrate;
			ArtistName=stationStatus.Artist;	
			artistImage.LoadArtistInfo((ArtistName));	
			trace("updating artist: " + ArtistName);
			
		}

		private function LoadXML(e:Event):void
		{
			xmlData = new XML(e.target.data);
			xmlData= xmlData.replace( String.fromCharCode(65279), "" ) ;
			ParseSettings(xmlData);
		}

		private function ParseSettings(Settings:XML):void
		{
			movieName.text = Settings.shoutcast.text();
			rtmpserver = Settings.rtmp.text();
			stationName.text = Settings.station.text();

			UrlStatusScriptLink = Settings.statusscriptlink.text();

			//Station.text=stationName.text;
			sCaption.text = Settings.caption.text();
			if (Settings.autoplay.text() == "yes")
			{
				doPlayPause();
			}			
		}

		private function playRadio():void
		{
			var netStreamClientObj:Object;
			var loc1:*;
						
			netStreamClientObj = null;
			netStream = new NetStream(netConnection);
			netStream.checkPolicyFile = true;
			netStream.addEventListener(flash.events.NetStatusEvent.NET_STATUS, netStreamOnStatus);
			netStream.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorHandler); 
			netStreamClientObj = new Object();
			netStream.client = netStreamClientObj;			

			netStreamClientObj.onCuePoint = function (infoObject:Object):void
			{
				//trace(infoObject);
			
			}
			
			netStreamClientObj.onHeaderData = function (metadata:Object):*			
			{
				//trace(metadata);
				
				var loc1:*;
				loc1 = null;
				var loc2:*;
				loc2 = null;
				loc1 = "";
				var loc3:*;
				loc3 = 0;
				var loc4:*;
				loc4 = metadata;
				
				for (loc2 in loc4)
				{
					if (!isDebugMode)
					{
						continue;
					}
					loc1 += loc2 + ": " + metadata[loc2] + "\n";
				}
				
				if (isDebugMode)
				{
					metaDataText.text = loc1;
				}
				else 
				{
					if (metadata["icy-genre"] != undefined)
					{
						metaDataValues["genre"] = metadata["icy-genre"];
					}
			
					if (metadata["icy-name"] != undefined)
					{
						metaDataValues["name"] = metadata["icy-name"];
					}
						updateMetaData();
				}
			}

			netStreamClientObj.onMetaData = function (metadata:Object):* 
			{
				var loc1:*;
				loc1 = null;
				var loc2:*;
				loc2 = null;
				loc1 = "";
				var loc3:*;
				loc3 = 0;
				var loc4:*;
				loc4 = metadata;
				for (loc2 in loc4)
				{
					if (!isDebugMode)
					{
						continue;
					}
					loc1 += loc2 + ": " + metadata[loc2] + "\n";
				}

				if(isDebugMode)
				{
					metaDataText.text = loc1;
				}
				else
				{
					if (metadata["StreamTitle"] != undefined)
					{
						metaDataValues["title"] = metadata["StreamTitle"];
					}
					if (metadata["StreamArtist"] != undefined)
					{
						metaDataValues["artist"] = metadata["StreamArtist"];
					}
					
					if (metadata["StreamUrl"] != undefined)
					{
						metaDataValues["url"] = metadata["StreamUrl"];
					}
					if (metadata["title"] != undefined)
					{
						metaDataValues["title"] = metadata["title"];
					}
					
					if (metadata["artist"] != undefined)
					{
						metaDataValues["artist"] = metadata["artist"];
					}
					updateMetaData();
				}
			}

			netStream.bufferTime = 2;
			netStream.seek(0);
			netStream.play(movieName.text);

			//get knob volume value and apply to audio object
			soundVolume.volume = knob.value;
			netStream.soundTransform = soundVolume;
		}
		private function asyncErrorHandler(event:AsyncErrorEvent):void 
		{ 
			//trace(event.text);
		
		}

		private function updateMetaData():void
		{
			var loc1:*;
			var songartist:String;
			var songartistname:String;
			var songartist_arr:Array;
			
			loc1 = undefined;
			loc1 = ""; //old
			nowPlaying = "";
			
			if (metaDataValues["artist"] != "")
			{
				loc1 += "Artist: " + metaDataValues["artist"] + "\n";
			}
			if (metaDataValues["title"] != "")
			{
				loc1 += "Title: " + metaDataValues["title"] + "\n";
			}
			if (metaDataValues["genre"] != "")
			{
				loc1 += "Genre: " + metaDataValues["genre"] + "\n";
			}
			if (metaDataValues["name"] != "")
			{
				loc1 += "Name: " + metaDataValues["name"] + "\n";
			}
			if (metaDataValues["url"] != "")
			{
				loc1 += "URL: " + metaDataValues["url"] + "\n";
			}
			metaDataText.text = loc1;
						
			if (metaDataValues["artist"] != "")
			{
				nowPlaying += metaDataValues["artist"] +  " - ";
			}
			if (metaDataValues["title"] != "")
			{
				nowPlaying += metaDataValues["title"];
			}
						
			songartist=metaDataValues["title"];
			songartist_arr = songartist.split("-")
			songartistname=trimWhitespace(songartist_arr[0]); 
			artistImage.LoadArtistInfo(songartistname);	
			nowPlayingScroller.nowPlaying.text = nowPlaying;				
			nowPlayingScroller.nowPlaying.width = nowPlayingScroller.nowPlaying.textWidth;
			nowPlayingScroller.nowPlaying.x = 5;			
			
			stationStatus.GetStatus(UrlStatusScriptLink);
			scrollTitle();
		}
		
		
		private function scrollTitle(){
					if(nowPlayingScroller.nowPlaying.width>300)
					{
						nowPlayingScroller.nowPlaying.x = 5;	
						Tweener.addTween(nowPlayingScroller.nowPlaying,{x:-800,time:30,delay:3,onUpdate:scroollupdate, transition:"linear",onComplete:scrollTitle});
					}else{
						nowPlayingScroller.nowPlaying.x = 5;
					}
		}		
		private function scroollupdate():void{
					//trace((nowPlayingScroller.nowPlaying.x) + " = " + (nowPlayingScroller.nowPlaying.width-315));
					if(nowPlayingScroller.nowPlaying.x<((nowPlayingScroller.nowPlaying.width-315)*-1)){
						Tweener.addTween(nowPlayingScroller.nowPlaying,{x:800,time:30,delay:3,onUpdate:scroollRightupdate,transition:"linear",onComplete:scrollTitle});
					}
		}
		private function scroollRightupdate():void{
					if(nowPlayingScroller.nowPlaying.x>5){
						scrollTitle();
					}
		}			
		
		
		private function btnPlayPausePauseClick(arg1:flash.events.Event):void
		{
			doPlayPause();
		}

		private function btnStopClick(arg1:flash.events.Event):void
		{
			doStop();
		}
		
		private function nowPlayingUpdater(arg1:flash.events.Event):void
		{				
			if(nowPlayingScroller.nowPlaying.textWidth > minScrollerTextLength)
			{
				if(isDirectionLeft)
				{
					nowPlayingScroller.nowPlaying.x -= scrollingSpeed;				
					if (nowPlayingScroller.nowPlaying.x < minPos)
					{
						isDirectionLeft = false;
					}			
				}
				else
				{
					nowPlayingScroller.nowPlaying.x += scrollingSpeed;
					if(nowPlayingScroller.nowPlaying.x > maxPos)
					{
						isDirectionLeft = true;
					}
				}
			}
		}
		
		private function netConnectionOnStatus(arg1:flash.events.NetStatusEvent):void
		{
			if (arg1.info.code == "NetConnection.Connect.Success") 
			{
				isTryingtoConnect = false;
				playRadio();
			}
			if (arg1.info.code == "NetConnection.Connect.Closed")
			{
				netConnection.removeEventListener(flash.events.NetStatusEvent.NET_STATUS, netConnectionOnStatus);
			}
		}
		
		private function netStreamOnStatus(arg1:flash.events.NetStatusEvent):void
		{
			if (arg1.info.code == "NetStream.Play.Start")
			{
				addEventListener(Event.ENTER_FRAME, equalizer.render);				
				addEventListener(Event.ENTER_FRAME, compute);
				timerDisp.StartCount();
				isConnected = true;
			}

			if (arg1.info.code == "NetStream.Play.StreamNotFound")
			{
				if (!isConnected)
				{
					doStop();
				}
			}

			if (arg1.info.code == "NetStream.Buffer.Flush")
			{
				//bufferFlush = true;
			}
			if (arg1.info.code == "NetStream.Buffer.Empty")
			{
				isConnected = false;
				doStop();
				isTryingtoConnect = true;
			}

			if (arg1.info.code == "NetStream.Play.Stop")
			{

			}
		}

		private function isLoaded(arg1:flash.events.Event):void
		{
			LogoLoader.addChild(myLoader);
			myLoader.scaleX = 1;
			myLoader.scaleY = 1;
		}

		private function doStop():void
		{
			if(netStream != null)
			{
				netStream.close();
				netStream = null;
			}

			if(netConnection != null)
			{
				netConnection.close();
				netConnection = null;
			}
			isConnected = false;			
			isPaused = false;
			metaDataValues["artist"] = "";
			metaDataValues["title"] = "";
			metaDataValues["genre"] = "";
			metaDataValues["name"] = "";
			metaDataValues["url"] = "";
			updateMetaData();			
			updateLabelText();
			livestatus.text = "OFFLINE";
			btnPlayPause.gotoAndStop("1");
			isTryingtoConnect = false;
			//Station.text="";
			tmrduration = "00:00";
			timerDisp.StopCount();
			nowPlayingScroller.nowPlaying.text = "";
			stationStatus.removeEventListener("ON_STATION_STATUS",updateStationStatus); 
			Listeners.text = "";
			Bitrate.text = "";
			Title.text = "";
			artistImage.UnloadImage();
		}

		private function doConnect():void
		{		
			isConnected = false;
			isTryingtoConnect = true;		
			updateLabelText();
			netConnection = new NetConnection();
			netConnection.addEventListener(flash.events.NetStatusEvent.NET_STATUS, netConnectionOnStatus);

			if (rtmpserver == "")
			{
				netConnection.connect(null);
			}
			else
			{
				netConnection.connect(rtmpserver);
			}
			
			isConnected = netConnection.connected; 
			stationStatus.addEventListener("ON_STATION_STATUS", updateStationStatus);
			btnPlayPause.gotoAndStop("2");
		}
		
		private function doPause():void
		{
			if (netStream != null && !isPaused)
			{
				netStream.pause();
				timerDisp.PauseCount();
				isPaused = true;				
				btnPlayPause.gotoAndStop("1");				
			}			
		}
		
		private function doResume():void
		{
			if (netStream != null)
			{
				netStream.resume();		
				timerDisp.ResumeCount();
				isPaused = false;						
				btnPlayPause.gotoAndStop("2");
			}
		}
		
		private function updateLabelText()
		{			
			if(!isPaused && !isTryingtoConnect && isConnected)
			{
				labelText = "Playing...";
			}
			else
			{				
				if(isTryingtoConnect && !isConnected)
				{
					labelText = "cargado...";
				}
				else if(!isConnected && !isTryingtoConnect)
				{
					labelText = "Stop";
				}				
				else if(isPaused)
				{
					labelText  = "Paused";
				}
				else
				{
					labelText = "";
				}
				labletxt.text = labelText;
			}
		}
				
		private function doPlayPause():void
		{
			if(isPaused)
			{
				doResume();
			}
			else if(!isPaused && isConnected)
			{
				doPause();
			}
			else
			{
				doConnect();
			}
			updateLabelText();
		}	
		private function trimWhitespace($string:String):String {
			if ($string == null) {
				return "";
			}
			return $string.replace(/^\s+|\s+$/g, "");
		}
		

		
	}
}