<?php

	include './../inc/functions.php';
	include './../inc/lib/image-resize.class.php';

	// Json only
	header( "Content-type: application/json" );
	$response = array();

	// Actions
	switch ( $_GET[ 'action' ] ) {

		case 'getArtwork':

			// Read list of files
			$files = browse( './../tmp/images/' );

			// Check if its array
			if ( is_array( $files ) AND count( $files ) >= 1 ) {

				// Loop
				foreach ( $files as $file ) {

					// Skip logo files
					if ( preg_match( '/logo\.[0-9]+/i', $file ) ) continue;

					// Create array of files to respond with
					$response[] = array(
						'name' => ext_del( basename( $file ) ),
						'path' => "tmp/images/{$file}",
						'size' => file_size( filesize( "./../tmp/images/{$file}" ) ),
					);

				}

				ksort( $response );

			}

			break;

		case 'delArtwork':
			delete_artist( $_GET[ 'name' ] );
			$response = array( 'success' => true );
			break;

		default:
			$response = array( 'error', 'nothing here!' );
			break;

	}


	echo json_encode( $response );
?>

